from os import getcwd, listdir
from re import finditer, MULTILINE
from os.path import split

work_dir = getcwd()
files_in_work_dir = listdir(work_dir)
data_files = [file for file in files_in_work_dir if file.endswith('.mp')]
general_data = {}
output_data = []
title = 'Time'
output_file = '_'.join(split(work_dir)[-1].split()) + '.txt'

with open(output_file,'w') as output_file:
    for file in data_files:
        tmp = file.split('.')[0]
        tmp = '_'.join(tmp.split())
        title = title + '\t' + tmp
        with open(file, 'r') as data_file:
            data = data_file.read()
        for match in finditer(r'^\s*(\d+(?:\.\d+)?)\s+(\d+)\s*$', data, flags=MULTILINE):
            time = match[1]
            signal = match[2]
            if time in general_data.keys():
                general_data[time] = general_data[time] + '\t' + signal
            else:
                general_data[time] = signal
    for key in general_data.keys():
        output_data.append(key + '\t' + general_data[key])
    output_data = '\n'.join(output_data)
    output_data = title + '\n' + output_data
    output_file.write(output_data)
